<?php

use Carbon_Fields\Container;
use Carbon_Fields\Field;

add_action('carbon_fields_register_fields', 'crb_attach_theme_options');
function crb_attach_theme_options()
{

    /*Настройки шаблона*/
    Container::make('theme_options', "Mostbet")
        ->set_icon('dashicons-sos')
        ->add_tab("Общее", array(
            Field::make('separator', 'head_block', "Шапка сайта"),
            Field::make('text', 'ref_android', "Ссылка Андроид приложения")->set_width(50),
            Field::make('text', 'ref_ios', "Ссылка IOS приложения")->set_width(50),
            Field::make('text', 'ref_register', "Ссылка кнопки Регистрация")->set_width(50),
            Field::make('text', 'ref_login', "Ссылка кнопки Вход")->set_width(50),
            Field::make('text', 'ref_all', "Реферальная ссылка на все остальное"),


            Field::make('separator', 'sidebar_left_block', "Сайдбар слева"),
            Field::make('text', 'sidebar_left_get_ref', "Получить - ссылка")->set_width(100),
            Field::make('text', 'sidebar_left_link1', "Меню слева - ссылка 1")->set_width(50),
            Field::make('text', 'sidebar_left_link2', "Меню слева - ссылка 2")->set_width(50),
            Field::make('text', 'sidebar_left_link3', "Меню слева - ссылка 3")->set_width(50),
            Field::make('text', 'sidebar_left_link4', "Меню слева - ссылка 4")->set_width(50),
            Field::make('text', 'sidebar_left_link5', "Меню слева - ссылка 5")->set_width(50),
            Field::make('text', 'sidebar_left_link6', "Меню слева - ссылка 6")->set_width(50),
            Field::make('text', 'sidebar_left_link7', "Меню слева - ссылка 7")->set_width(50),
            Field::make('text', 'sidebar_left_link8', "Меню слева - ссылка 8")->set_width(50),
            Field::make('text', 'sidebar_left_link9', "Меню слева - ссылка 9")->set_width(50),
            Field::make('text', 'sidebar_left_link10', "Меню слева - ссылка 10")->set_width(50),


            Field::make('separator', 'sidebar_right_block', "Сайдбар справа"),
            Field::make('text', 'get_now', "Получить сейчас - ссылка")->set_width(50),
            Field::make('text', 'register_ref', "Зарегистрироваться - ссылка")->set_width(50),
            Field::make('text', 'sidebar_slots_name', "Заголовок первого блока")->set_width(50),
            Field::make('text', 'sidebar_slots_link', "Ссылка заголовка первого блока")->set_width(50),
            Field::make('association', 'sidebar_slots1', __('Выбрать слоты для первого блока'))
                ->set_types(array(
                    array(
                        'type' => 'post',
                        'post_type' => 'slots',
                    )
                )),
            Field::make('text', 'sidebar_slots_name2', "Заголовок второго блока")->set_width(50),
            Field::make('text', 'sidebar_slots_link2', "Ссылка заголовка второго блока")->set_width(50),
            Field::make('association', 'sidebar_slots2', __('Выбрать слоты для второго блока'))
                ->set_types(array(
                    array(
                        'type' => 'post',
                        'post_type' => 'slots',
                    )
                )),


            Field::make('separator', 'footer_block', "Футер сайта"),
            Field::make('text', 'ref_android2', "Ссылка Андроид приложения (футер)")->set_width(50),
            Field::make('text', 'ref_ios2', "Ссылка IOS приложения (футер)")->set_width(50),
            Field::make('textarea', 'code', "Код в футере"),
        ))
        ->add_tab("Слайдер", array(
                Field::make('complex', 'slider', __('Слайды'))
                    ->add_fields(array(
                        Field::make('image', 'img', __('Картинка слайда'))->set_width(50),
                        Field::make('text', 'link', __('Ссылка '))->set_width(50),

                    )),
            )
        );


    Container::make('nav_menu_item', 'Настройки меню')
        ->add_fields(array(
            Field::make('textarea', 'svg', 'SVG картинка для меню'),
        ));


    /*Cлотs*/


    Container::make('post_meta', "Опции слотов")
        ->where('post_type', '=', 'slots')
        ->add_fields(array(
            Field::make('text', 'demo', 'Фрейм'),

        ));
    Container::make('post_meta', "Опции страниц и записей")
        ->where('post_type', '=', 'page')
        ->or_where('post_type', '=', 'post')
        ->or_where('post_type', '=', 'slots')
        ->add_fields(array(
            Field::make('text', 'text_download', 'Реф ссылка кнопки скачать которая возле названия'),

        ));

    /*Тип слота*/
    Container::make('term_meta', __("Deposit method fields", "jgambling"))
        ->where('term_taxonomy', '=', 'type')
        ->add_fields(array(

            Field::make('textarea', 'icon', 'SVG иконка'),
        ));


}

add_action('after_setup_theme', 'crb_load');
function crb_load()
{
    require_once(get_template_directory() . '/inc/libs/carbon-fields/vendor/autoload.php');
    \Carbon_Fields\Carbon_Fields::boot();

    /*  Подключение всех Gutenberg блоков  */
    include 'blocks/slots-list.php';
    include 'blocks/faq-list.php';
}
