<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <?php wp_head(); ?>
</head>
<?php
$all_links = carbon_get_theme_option('ref_all');
$ref_android = carbon_get_theme_option('ref_android');
$ref_ios = carbon_get_theme_option('ref_ios');
$ref_register = carbon_get_theme_option('ref_register');
$ref_login = carbon_get_theme_option('ref_login');

?>
<body <?php body_class(); ?>>
<header>
    <div class="headerTop">
        <div class="header__flex">

            <div class="open-menu">
                <span></span>
                <span></span>
                <span></span>
            </div>

            <div class="download-block">
                <span><?php echo __('DOWNLOAD:', 'mostbet'); ?></span>
                <a class="download-icon" href="<?php echo $ref_android; ?>" target="_blank" rel="nofollow">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" preserveAspectRatio="">
                        <path d="M4 15c0 1.1.9 2 2 2v2c0 .6.4 1 1 1s1-.4 1-1v-2h4v2c0 .6.4 1 1 1s1-.4 1-1v-2c1.1 0 2 .1 2-1V9H4v6zM2 8c-.6 0-1 .5-1 1v5c0 .6.4 1 1 1s1-.4 1-1V9c0-.5-.4-1-1-1zm12.7-6.2c.4-.4.4-1.1 0-1.5-.4-.4-1.1-.4-1.5 0l-1.1 1.1c-.7-.2-1.4-.4-2.1-.4-.7 0-1.4.2-2.1.4L6.8.3c-.4-.4-1.1-.4-1.5 0-.4.4-.4 1.1 0 1.5l.8.8C4.8 3.8 4 5.5 4 7.4V8h12v-.6c0-2-.8-3.7-2.1-4.9l.8-.7zM7.5 7C6.7 7 6 6.3 6 5.5S6.7 4 7.5 4 9 4.7 9 5.5 8.3 7 7.5 7zM14 5.5c0 .8-.7 1.5-1.5 1.5S11 6.3 11 5.5 11.7 4 12.5 4s1.5.7 1.5 1.5zM18 8c-.6 0-1 .4-1 1v5c0 .6.4 1 1 1s1-.4 1-1V9c0-.5-.4-1-1-1z"></path>
                    </svg>
                </a>
                <a class="download-icon" href="<?php echo $ref_ios; ?>" target="_blank" rel="nofollow">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" preserveAspectRatio="">
                        <path d="M17.4 14.9c-.2-.1-2.3-1-2.3-3.5 0-2 1.5-3.1 1.9-3.3v-.2C15.9 6.3 14.2 6 13.6 6h-.3c-.8 0-1.5.3-2.1.5-.4.2-.8.3-1 .3-.3 0-.6-.1-1.1-.3-.6-.2-1.2-.5-1.9-.5-1.6 0-3 .9-3.9 2.3-1.5 2.7-.6 6.8 1.1 9.3.9 1.3 1.8 2.4 2.9 2.4h.1c.6 0 1-.2 1.3-.4.4-.2.9-.4 1.6-.4.7 0 1.1.2 1.5.4.4.2.8.4 1.5.3 1.3 0 2.2-1.2 2.9-2.3.8-1.1 1.1-2.2 1.3-2.6 0 0 0-.1-.1-.1zM9.7 5h.2c1 .1 2-.5 2.7-1.4.7-1 1-2.3.9-3.4 0-.1-.1-.2-.2-.2-1 0-2.2.6-2.8 1.5-.6.7-1.1 2-.9 3.3-.1.1 0 .2.1.2z"></path>
                    </svg>
                </a>
            </div>

            <button class="bypassing-btn" type="button">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" preserveAspectRatio="">
                    <path d="M13.7 5.9l-5 4.1-2-1.5-1.5 1.3 3.4 3.8 6.1-6.2-1-1.5zM10 0L0 4.2S.7 20 10 20 20 4.2 20 4.2L10 0zm0 18C4.1 18 2.5 9 2.1 5.5L10 2.2l7.9 3.3C17.5 9 15.9 18 10 18z"></path>
                </svg>
                <span><?php echo __('WEBSITE ACCESS:', 'mostbet'); ?></span>
            </button>

            <div class="settings__main">
                <div class="settings__cnt">
                    <div class="settings__bnt">
                        <div class="settings__icon">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" preserveAspectRatio="">
                                <path d="M10 6c-2.2 0-4 1.8-4 4s1.8 4 4 4 4-1.8 4-4-1.8-4-4-4zm0 6c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2zm9.5-3.9l-1.3-.6c0-.2-.1-.3-.2-.5l.7-1.2c.2-.3.2-.6 0-.9-.4-.7-.8-1.3-1.3-1.8-.2-.2-.6-.4-.9-.3l-1.3.3c-.1-.1-.3-.2-.4-.3l-.1-1.4c0-.3-.2-.6-.5-.7-.7-.3-1.4-.5-2.1-.7-.3-.1-.7 0-.9.3l-.9 1.1h-.5l-1-1C8.6.1 8.3 0 8 .1c-.8.1-1.5.4-2.2.7-.3.1-.5.4-.5.7l-.1 1.4c-.1.1-.3.2-.4.3l-1.3-.3c-.3-.1-.7 0-.9.3-.5.5-1 1.1-1.3 1.8-.2.3-.2.6 0 .9L2 7.1c-.1.2-.1.3-.2.5l-1.3.5c-.3.2-.5.5-.5.9v2c0 .4.2.7.5.8l1.3.6c0 .2.1.3.2.5l-.7 1.2c-.2.3-.2.6 0 .9.4.7.8 1.3 1.3 1.8.2.2.6.4.9.3l1.3-.3c.1.1.3.2.4.3l.1 1.4c0 .3.2.6.5.7.7.3 1.4.5 2.1.7.3.1.7 0 .9-.3l.9-1.1h.4l.9 1.1c.2.2.4.3.7.3h.2c.7-.2 1.4-.4 2.1-.7.3-.1.5-.4.5-.7l.1-1.4c.1-.1.3-.2.4-.3l1.3.3c.3.1.7 0 .9-.3.5-.6.9-1.2 1.3-1.8.2-.3.2-.6 0-.9l-.5-1.2c.1-.2.1-.3.2-.5l1.3-.6c.3-.1.5-.5.5-.8V9c0-.4-.2-.7-.5-.9zM18 10.3l-1.5.7-.3.9c0 .1-.1.3-.1.4l-.3.9.8 1.4c-.1.2-.2.3-.3.5l-1.6-.4-.7.5c-.1.1-.2.2-.3.2l-.8.6-.2 1.7c-.2.1-.3.1-.5.2l-1.1-1.3H8.9l-1.1 1.3c-.2-.1-.4-.1-.5-.2L7.1 16l-.8-.5c-.1-.1-.2-.1-.3-.2l-.7-.6-1.6.3c-.1-.2-.2-.3-.3-.5l.8-1.4-.3-.9c0-.1-.1-.3-.1-.4l-.3-.8-1.5-.7v-.6L3.5 9l.3-.9c0-.1.1-.3.1-.4l.3-.9-.9-1.4c.1-.1.2-.3.4-.4l1.6.4.7-.6c.1-.1.2-.2.3-.2l.8-.6.2-1.7c.2-.1.3-.1.5-.2l1.1 1.3h2.3l1.1-1.3c.2.1.4.1.5.2l.1 1.7.8.5c.1.1.2.2.3.2l.7.6 1.6-.3c.1.2.2.3.3.5l-.8 1.4.3.9c0 .1.1.3.1.4l.3.8 1.5.7v.6z"></path>
                            </svg>
                        </div>
                        <span class="settings__name open-settings"><?php echo __('DECIMAL', 'mostbet'); ?></span>
                        <div class="arrow-animates">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 451.847 451.847" class=""
                                 preserveAspectRatio="">
                                <path d="M225.923 354.706c-8.098 0-16.195-3.092-22.369-9.263L9.27 151.157c-12.359-12.359-12.359-32.397 0-44.751 12.354-12.354 32.388-12.354 44.748 0l171.905 171.915 171.906-171.909c12.359-12.354 32.391-12.354 44.744 0 12.365 12.354 12.365 32.392 0 44.751L248.292 345.449c-6.177 6.172-14.274 9.257-22.369 9.257z"></path>
                            </svg>
                        </div>
                    </div>
                    <div class="settings__drop drop-style">
                        <div class="settings__format">
                            <div class="settings__fl">
                                <div class="settings__icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" class=""
                                         preserveAspectRatio="">
                                        <path d="M10 6c-2.2 0-4 1.8-4 4s1.8 4 4 4 4-1.8 4-4-1.8-4-4-4zm0 6c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2zm9.5-3.9l-1.3-.6c0-.2-.1-.3-.2-.5l.7-1.2c.2-.3.2-.6 0-.9-.4-.7-.8-1.3-1.3-1.8-.2-.2-.6-.4-.9-.3l-1.3.3c-.1-.1-.3-.2-.4-.3l-.1-1.4c0-.3-.2-.6-.5-.7-.7-.3-1.4-.5-2.1-.7-.3-.1-.7 0-.9.3l-.9 1.1h-.5l-1-1C8.6.1 8.3 0 8 .1c-.8.1-1.5.4-2.2.7-.3.1-.5.4-.5.7l-.1 1.4c-.1.1-.3.2-.4.3l-1.3-.3c-.3-.1-.7 0-.9.3-.5.5-1 1.1-1.3 1.8-.2.3-.2.6 0 .9L2 7.1c-.1.2-.1.3-.2.5l-1.3.5c-.3.2-.5.5-.5.9v2c0 .4.2.7.5.8l1.3.6c0 .2.1.3.2.5l-.7 1.2c-.2.3-.2.6 0 .9.4.7.8 1.3 1.3 1.8.2.2.6.4.9.3l1.3-.3c.1.1.3.2.4.3l.1 1.4c0 .3.2.6.5.7.7.3 1.4.5 2.1.7.3.1.7 0 .9-.3l.9-1.1h.4l.9 1.1c.2.2.4.3.7.3h.2c.7-.2 1.4-.4 2.1-.7.3-.1.5-.4.5-.7l.1-1.4c.1-.1.3-.2.4-.3l1.3.3c.3.1.7 0 .9-.3.5-.6.9-1.2 1.3-1.8.2-.3.2-.6 0-.9l-.5-1.2c.1-.2.1-.3.2-.5l1.3-.6c.3-.1.5-.5.5-.8V9c0-.4-.2-.7-.5-.9zM18 10.3l-1.5.7-.3.9c0 .1-.1.3-.1.4l-.3.9.8 1.4c-.1.2-.2.3-.3.5l-1.6-.4-.7.5c-.1.1-.2.2-.3.2l-.8.6-.2 1.7c-.2.1-.3.1-.5.2l-1.1-1.3H8.9l-1.1 1.3c-.2-.1-.4-.1-.5-.2L7.1 16l-.8-.5c-.1-.1-.2-.1-.3-.2l-.7-.6-1.6.3c-.1-.2-.2-.3-.3-.5l.8-1.4-.3-.9c0-.1-.1-.3-.1-.4l-.3-.8-1.5-.7v-.6L3.5 9l.3-.9c0-.1.1-.3.1-.4l.3-.9-.9-1.4c.1-.1.2-.3.4-.4l1.6.4.7-.6c.1-.1.2-.2.3-.2l.8-.6.2-1.7c.2-.1.3-.1.5-.2l1.1 1.3h2.3l1.1-1.3c.2.1.4.1.5.2l.1 1.7.8.5c.1.1.2.2.3.2l.7.6 1.6-.3c.1.2.2.3.3.5l-.8 1.4.3.9c0 .1.1.3.1.4l.3.8 1.5.7v.6z"></path>
                                    </svg>
                                </div>
                                <span class="settings__name"><?php echo __('Format', 'mostbet'); ?></span>
                            </div>
                            <div class="arrow-animates">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 451.847 451.847"
                                     class="Icon_icon__w6Pjo" preserveAspectRatio="">
                                    <path d="M225.923 354.706c-8.098 0-16.195-3.092-22.369-9.263L9.27 151.157c-12.359-12.359-12.359-32.397 0-44.751 12.354-12.354 32.388-12.354 44.748 0l171.905 171.915 171.906-171.909c12.359-12.354 32.391-12.354 44.744 0 12.365 12.354 12.365 32.392 0 44.751L248.292 345.449c-6.177 6.172-14.274 9.257-22.369 9.257z"></path>
                                </svg>
                            </div>
                        </div>
                        <div class="settings__crist scroll-style">
                            <ul>
                                <li><?php echo __('Decimal', 'mostbet'); ?></li>
                                <li><?php echo __('British', 'mostbet'); ?></li>
                                <li><?php echo __('American', 'mostbet'); ?></li>
                                <li><?php echo __('Hong-Kong', 'mostbet'); ?></li>
                                <li><?php echo __('Indonesian', 'mostbet'); ?></li>
                                <li><?php echo __('Malaysian', 'mostbet'); ?></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="head-clock">
                    <div class="head-clock__btn">
                        <span class="head-clock-numb"><?php echo date('H:i'); ?></span>
                        <div class="arrow-animates">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 451.847 451.847" class=""
                                 preserveAspectRatio="">
                                <path d="M225.923 354.706c-8.098 0-16.195-3.092-22.369-9.263L9.27 151.157c-12.359-12.359-12.359-32.397 0-44.751 12.354-12.354 32.388-12.354 44.748 0l171.905 171.915 171.906-171.909c12.359-12.354 32.391-12.354 44.744 0 12.365 12.354 12.365 32.392 0 44.751L248.292 345.449c-6.177 6.172-14.274 9.257-22.369 9.257z"></path>
                            </svg>
                        </div>
                    </div>
                    <div class="head-clock__drop drop-style">
                        <div class="settings__format">
                            <div class="settings__icon">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" class=""
                                     preserveAspectRatio="">
                                    <path d="M14 9h-3V5c0-.6-.4-1-1-1s-1 .4-1 1v5c0 .6.4 1 1 1h4c.6 0 1-.4 1-1s-.4-1-1-1zm-4-9C4.5 0 0 4.5 0 10s4.5 10 10 10 10-4.5 10-10S15.5 0 10 0zm1 17.9V17c0-.6-.4-1-1-1s-1 .4-1 1v.9c-3.6-.5-6.5-3.3-6.9-6.9H3c.6 0 1-.4 1-1s-.4-1-1-1h-.9c.5-3.9 3.8-7 7.9-7 4.4 0 8 3.6 8 8 0 4.1-3.1 7.4-7 7.9z"></path>
                                </svg>
                            </div>
                            <span class="head-clock-numb">01:01</span>
                            <div class="arrow-animates">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 451.847 451.847"
                                     class="" preserveAspectRatio="">
                                    <path d="M225.923 354.706c-8.098 0-16.195-3.092-22.369-9.263L9.27 151.157c-12.359-12.359-12.359-32.397 0-44.751 12.354-12.354 32.388-12.354 44.748 0l171.905 171.915 171.906-171.909c12.359-12.354 32.391-12.354 44.744 0 12.365 12.354 12.365 32.392 0 44.751L248.292 345.449c-6.177 6.172-14.274 9.257-22.369 9.257z"></path>
                                </svg>
                            </div>
                        </div>
                        <div class="head-clock__get scroll-style">
                            <ul>
                                <li>UTC+1</li>
                                <li>UTC+2</li>
                                <li>UTC+3</li>
                                <li>UTC+4</li>
                                <li>UTC+5</li>
                            </ul>
                        </div>
                    </div>
                </div>


                <div class="head-lang">
                    <div class="head-lang__btn">
                        <div class="lang-round">
                            <img src="<?php echo get_template_directory_uri() ?>/assets/img/flag-az.svg"
                                 class="flag-image" alt="flag">
                            <span class="head-clock-numb">AZ</span>
                        </div>
                        <div class="arrow-animates">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 451.847 451.847"
                                 class="">
                                <path d="M225.923 354.706c-8.098 0-16.195-3.092-22.369-9.263L9.27 151.157c-12.359-12.359-12.359-32.397 0-44.751 12.354-12.354 32.388-12.354 44.748 0l171.905 171.915 171.906-171.909c12.359-12.354 32.391-12.354 44.744 0 12.365 12.354 12.365 32.392 0 44.751L248.292 345.449c-6.177 6.172-14.274 9.257-22.369 9.257z"></path>
                            </svg>
                        </div>
                    </div>
                    <div class="head-lang__drop drop-style">
                        <div class="settings__format">
                            <div class="settings__fl">
                                <img src="<?php echo get_template_directory_uri() ?>/assets/img/flag-az.svg"
                                     class="flag-image" alt="flag">
                                <span class="settings__name">AZ </span>
                            </div>
                            <div class="arrow-animates">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 451.847 451.847"
                                     class="Icon_icon__w6Pjo" preserveAspectRatio="">
                                    <path d="M225.923 354.706c-8.098 0-16.195-3.092-22.369-9.263L9.27 151.157c-12.359-12.359-12.359-32.397 0-44.751 12.354-12.354 32.388-12.354 44.748 0l171.905 171.915 171.906-171.909c12.359-12.354 32.391-12.354 44.744 0 12.365 12.354 12.365 32.392 0 44.751L248.292 345.449c-6.177 6.172-14.274 9.257-22.369 9.257z"></path>
                                </svg>
                            </div>
                        </div>
                        <div class="head-clock__crist scroll-style">
                            <ul>

                                <li>
                                    <a href="#">
                                        <img src="<?php echo get_template_directory_uri() ?>/assets/img/en.svg"
                                             class="flag-image" alt="flag">
                                        <span class="head-clock-numb">EN</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="#">
                                        <img src="<?php echo get_template_directory_uri() ?>/assets/img/flag-az.svg"
                                             class="flag-image" alt="flag">
                                        <span class="head-clock-numb">AZ</span>
                                    </a>
                                </li>

                                <li>
                                    <a href="#">
                                        <img src="<?php echo get_template_directory_uri() ?>/assets/img/hy.svg"
                                             class="flag-image" alt="flag">
                                        <span class="head-clock-numb">HY</span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>


            </div>
            <a class="free-money" href="<?php echo $all_links; ?>" target="_blank" rel="nofollow">free money
                <span class="free-money__icon"></span>
            </a>
            <div class="head-stock">
                <div class="head-stock__btn">
                    <div class="head-stock__icon">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" class="Icon_icon__w6Pjo"
                             preserveAspectRatio="">
                            <path d="M18 11v7c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2v-7c-1.1 0-2-.9-2-2V7c0-1.1.9-2 2-2h2.3C4.1 4.5 4 4 4 3.5 4 1.6 5.6 0 7.5 0c1 0 1.9.4 2.5 1.1.6-.7 1.5-1.1 2.5-1.1C14.4 0 16 1.6 16 3.5c0 .5-.1 1-.3 1.5H18c1.1 0 2 .9 2 2v2c0 1.1-.9 2-2 2zm-2 7v-7h-5v7zM4 18h5v-7H4zM7.5 2C6.7 2 6 2.7 6 3.5S6.7 5 7.5 5H9V3.5C9 2.7 8.3 2 7.5 2zm5 0c-.8 0-1.5.7-1.5 1.5V5h1.5c.8 0 1.5-.7 1.5-1.5S13.3 2 12.5 2zM18 7H2v2h16z"></path>
                        </svg>
                    </div>
                    <?php echo __('Offers', 'mostbet'); ?>
                </div>
                <div class="head-stock__drop drop-style">
                    <div class="settings__format">
                        <div class="settings__fl">
                            <div class="head-stock__icon">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" class=""
                                     preserveAspectRatio="">
                                    <path d="M18 11v7c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2v-7c-1.1 0-2-.9-2-2V7c0-1.1.9-2 2-2h2.3C4.1 4.5 4 4 4 3.5 4 1.6 5.6 0 7.5 0c1 0 1.9.4 2.5 1.1.6-.7 1.5-1.1 2.5-1.1C14.4 0 16 1.6 16 3.5c0 .5-.1 1-.3 1.5H18c1.1 0 2 .9 2 2v2c0 1.1-.9 2-2 2zm-2 7v-7h-5v7zM4 18h5v-7H4zM7.5 2C6.7 2 6 2.7 6 3.5S6.7 5 7.5 5H9V3.5C9 2.7 8.3 2 7.5 2zm5 0c-.8 0-1.5.7-1.5 1.5V5h1.5c.8 0 1.5-.7 1.5-1.5S13.3 2 12.5 2zM18 7H2v2h16z"></path>
                                </svg>
                            </div>
                            <span class="settings__name"> <?php echo __('Offers', 'mostbet'); ?></span>
                        </div>
                        <div class="arrow-animates">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 451.847 451.847"
                                 class="Icon_icon__w6Pjo" preserveAspectRatio="">
                                <path d="M225.923 354.706c-8.098 0-16.195-3.092-22.369-9.263L9.27 151.157c-12.359-12.359-12.359-32.397 0-44.751 12.354-12.354 32.388-12.354 44.748 0l171.905 171.915 171.906-171.909c12.359-12.354 32.391-12.354 44.744 0 12.365 12.354 12.365 32.392 0 44.751L248.292 345.449c-6.177 6.172-14.274 9.257-22.369 9.257z"></path>
                            </svg>
                        </div>
                    </div>
                    <div class="head-stock__link">
                        <a class="head-stock__href" href="<?php echo $all_links; ?>">
                            <div class="head-stock__icon">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" class=""
                                     preserveAspectRatio="">
                                    <path d="M18 11v7c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2v-7c-1.1 0-2-.9-2-2V7c0-1.1.9-2 2-2h2.3C4.1 4.5 4 4 4 3.5 4 1.6 5.6 0 7.5 0c1 0 1.9.4 2.5 1.1.6-.7 1.5-1.1 2.5-1.1C14.4 0 16 1.6 16 3.5c0 .5-.1 1-.3 1.5H18c1.1 0 2 .9 2 2v2c0 1.1-.9 2-2 2zm-2 7v-7h-5v7zM4 18h5v-7H4zM7.5 2C6.7 2 6 2.7 6 3.5S6.7 5 7.5 5H9V3.5C9 2.7 8.3 2 7.5 2zm5 0c-.8 0-1.5.7-1.5 1.5V5h1.5c.8 0 1.5-.7 1.5-1.5S13.3 2 12.5 2zM18 7H2v2h16z"></path>
                                </svg>
                            </div>
                            <span class="settings__name"> <?php echo __('Offers', 'mostbet'); ?></span>
                        </a>
                        <a class="head-stock__href" href="<?php echo $all_links; ?>">
                            <div class="head-stock__icon">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 21 20" class=""
                                     preserveAspectRatio="">
                                    <path d="M8.539 20a.913.913 0 01-.655-.272L.46 12.288a.925.925 0 010-1.304l8.424-8.45a.925.925 0 01.651-.273l2.776.268A4.082 4.082 0 0116.097 0c1.098.002 2.13.43 2.904 1.207a4.124 4.124 0 010 5.817 4.063 4.063 0 01-1.372.906l.254 2.608a.915.915 0 01-.266.741l-8.423 8.45a.915.915 0 01-.655.272zm0-2.232l7.493-7.518-.232-2.036a4.095 4.095 0 01-2.609-1.19.925.925 0 011.31-1.305 2.23 2.23 0 001.114.603l-.158-1.628-5.572-.546-7.464 7.487zm7.794-14.845a.908.908 0 01.628.273.916.916 0 01.27.631l.204 2.108c.095-.068.179-.14.256-.217a2.274 2.274 0 000-3.207 2.235 2.235 0 00-1.594-.662 2.238 2.238 0 00-1.78.876zM8.507 15.935a.987.987 0 01-.176-.017 1.166 1.166 0 01-.173-.052 1.529 1.529 0 01-.16-.083c-.07-.054-.109-.082-.144-.117L6.472 14.28a.923.923 0 111.31-1.304l.724.726.698-.699a.923.923 0 111.31 1.304l-1.352 1.356c-.092.077-.118.1-.145.118l-.145-.035.046.088c-.108.052-.156.064-.204.076a.9.9 0 01-.207.025z"></path>
                                </svg>
                            </div>
                            <span class="settings__name"> <?php echo __('Bonuses', 'mostbet'); ?></span>
                        </a>
                        <a class="head-stock__href" href="<?php echo $all_links; ?>">
                            <div class="head-stock__icon">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 18 20" class=""
                                     preserveAspectRatio="">
                                    <path d="M16 6a3.001 3.001 0 00-2-2.83V8c0 .291-.025.576-.073.854A3.001 3.001 0 0016 6zm2 0a5 5 0 01-5 5 5 5 0 01-3 1.9V14h2a3 3 0 013 3v1h2a1 1 0 010 2H1a1 1 0 010-2h2v-1a3 3 0 013-3h2v-1.1A5 5 0 015 11a5 5 0 01-1-9.9V1a1 1 0 011-1h8a1 1 0 011 1v.1c2.282.463 4 2.481 4 4.9zM2 6c0 1.333.87 2.463 2.073 2.854A5.032 5.032 0 014 8V3.17A3.001 3.001 0 002 6zm10-4H6v6a3 3 0 006 0zm1 15a1 1 0 00-1-1H6a1 1 0 00-1 1v1h8z"></path>
                                </svg>
                            </div>
                            <span class="settings__name"> <?php echo __('Tournament', 'mostbet'); ?></span>
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <div class="header__btn">
            <button type="button" class="btn-registration" onclick="window.open('<?php echo $ref_register; ?>')">
                <?php echo __('Sign Up', 'mostbet'); ?>
            </button>
            <button type="button" class="btn-login" onclick="window.open('<?php echo $ref_login; ?>')">
                <?php echo __('Log in', 'mostbet'); ?>
            </button>
        </div>

    </div>

    <div class="headerBottom">
        <a class="header__logo" href="<?php echo home_url() ?>">
            <img alt="Mostbet Logo" class="logo-desktop"
                 src="<?php echo get_template_directory_uri() ?>/assets/img/mostbet-logo.png">
            <img alt="Mostbet Logo mobile" class="logo-mobile"
                 src="<?php echo get_template_directory_uri() ?>/assets/img/mostbet-logo-mobile.png">
        </a>

        <?php
        $result = wp_nav_menu(array(
            'container' => 'nav',
            'container_class' => 'header__nav',
            'add_a_class' => 'header__link',
            'depth' => 0,
            'items_wrap' => '%3$s',
            'theme_location' => 'top',
            'echo' => false,
        ));
        if ($result):
            $string = preg_replace("/<li.*?>(.*)?<\/li>/im", "$1", $result);
            echo $string;
        endif;
        ?>
    </div>


    <?php
    $sidebar_left_link1 = carbon_get_theme_option('sidebar_left_link1');
    $sidebar_left_link2 = carbon_get_theme_option('sidebar_left_link2');
    $sidebar_left_link3 = carbon_get_theme_option('sidebar_left_link3');
    $sidebar_left_link4 = carbon_get_theme_option('sidebar_left_link4');
    $sidebar_left_link5 = carbon_get_theme_option('sidebar_left_link5');
    $sidebar_left_link6 = carbon_get_theme_option('sidebar_left_link6');
    $sidebar_left_link7 = carbon_get_theme_option('sidebar_left_link7');
    $sidebar_left_link8 = carbon_get_theme_option('sidebar_left_link8');
    $sidebar_left_link9 = carbon_get_theme_option('sidebar_left_link9');
    $sidebar_left_link10 = carbon_get_theme_option('sidebar_left_link10');
    ?>
    <div class="head-mob__block">
        <div class="close-menu">
            <span></span>
            <span></span>
        </div>
        <div class="head-mob__scrall">
            <div class="head-mob__fon">
                <div class="first-deposit">
                    <div class="first-deposit__info">
                        <div class="first-deposit__item">
                            <span class="first-dep-numb">500</span>
                            <span class="first-dep-mon">AZN</span>
                            <div class="first-deposit__shadow">
                                <span>500</span>
                                <span>AZN</span>
                            </div>
                        </div>
                        <div class="first-deposit__name"><?php echo __('ON FIRST DEPOSIT', 'mostbet'); ?></div>
                        <button type="button" class="btn-registration"><?php echo __('Claim', 'mostbet'); ?></button>
                    </div>
                    <div class="first-deposit__elems">
                        <div class="first-deposit__soccer"></div>
                        <div class="first-deposit__coinTop"></div>
                        <div class="first-deposit__coinBottom"></div>
                        <div class="first-deposit__cap"></div>
                    </div>
                </div>
                <ul class="promotion__item">
                    <li>
                        <a class="promotion__link" href="<?php echo $sidebar_left_link1; ?>" target="_blank"
                           rel="nofollow">
                            <div class="promotion__icon">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 33 40">
                                    <path d="M24.405 39.997c-.428 0-.826-.27-.964-.693a.994.994 0 01.655-1.254c3.702-1.17 6.825-7.335 6.825-10.586 0-4.084-2.28-8.047-7.175-12.471-4.602-4.16-6.7-7.418-6.6-10.255.015-.399.073-.787.176-1.164-3.126 1.844-5.622 4.635-4.956 8.064.485 2.497 1.37 3.581 2.152 4.538.767.938 1.559 1.907 1.427 3.733-.108 1.481-.96 2.616-2.402 3.195-1.894.762-4.69.438-5.983-.69-1.15-1.004-1.769-2.226-1.831-3.517-2.18 2.14-3.732 5.761-3.732 9.166 0 2.801 1.722 5.583 5.264 8.505a.987.987 0 01.126 1.405 1.023 1.023 0 01-1.426.124c-4.03-3.324-5.99-6.606-5.99-10.034 0-5.278 2.993-10.624 6.961-12.433.4-.182.873-.089 1.17.23a.985.985 0 01.136 1.168c-1.05 1.82-.218 3.122.665 3.893.586.511 2.555.865 3.875.336.73-.293 1.094-.767 1.147-1.49.075-1.044-.279-1.477-.984-2.34-.837-1.025-1.984-2.43-2.564-5.414C9.245 6.186 14.818 1.986 19.935.16c.466-.168.987.024 1.229.45a.988.988 0 01-.252 1.267c-1.134.89-1.704 1.85-1.742 2.93-.075 2.15 1.925 5.083 5.946 8.716 5.342 4.828 7.83 9.259 7.83 13.941 0 3.888-3.534 11-8.231 12.485a1.02 1.02 0 01-.31.048zm-2.92-.824a1.02 1.02 0 01-.634-.22.987.987 0 01-.156-1.401c2.56-3.14 1.974-5.153 1.233-7.701-.316-1.089-.66-2.27-.724-3.585-1.258 1.199-1.73 2.543-2.114 3.925-.754 2.717-3.171 4.786-5.622 4.813-1.692.027-2.783-.81-3.517-1.78-.063 1.9.998 3.097 2.213 4.227a.987.987 0 01.04 1.41 1.023 1.023 0 01-1.43.04c-1.367-1.27-4.213-3.916-2.06-8.989a1.02 1.02 0 011.898.082c.864 2.667 1.86 2.996 2.833 3.015 1.528-.017 3.185-1.517 3.692-3.344.586-2.11 1.485-4.516 4.755-6.362a1.027 1.027 0 011.106.064.99.99 0 01.385 1.023c-.415 1.793.026 3.308.492 4.911.757 2.604 1.615 5.555-1.6 9.5-.2.245-.495.372-.79.372z"></path>
                                </svg>
                            </div>
                            <span><?php echo __('Popular', 'mostbet'); ?></span>
                        </a>
                    </li>
                    <li>
                        <a class="promotion__link" href="<?php echo $sidebar_left_link2; ?>" target="_blank"
                           rel="nofollow">
                            <div class="promotion__icon">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 40 41">
                                    <path d="M20.375 40.902l-3.183-2.418-3.763 1.312-2.173-3.375-3.982-.068-.9-3.924-3.718-1.442.479-4-3.007-2.642 1.803-3.593-1.932-3.522 2.906-2.753-.625-3.98 3.663-1.58.758-3.955 3.974-.217 2.049-3.455 3.808 1.171 3.092-2.537 3.184 2.42 3.763-1.314 2.173 3.376 3.98.067.903 3.925 3.717 1.442-.479 4 3.006 2.642-1.802 3.593 1.932 3.522-2.906 2.753.625 3.98-3.663 1.58-.758 3.955-3.974.217-2.049 3.455-3.809-1.171zm-2.832-4.68l2.786 2.116 2.705-2.22 3.331 1.026 1.793-3.022 3.477-.19.663-3.461 3.204-1.383-.547-3.48 2.543-2.409-1.69-3.082 1.576-3.144-2.63-2.31.42-3.5-3.252-1.262-.79-3.433-3.482-.06-1.902-2.953-3.291 1.15-2.786-2.117-2.706 2.22-3.33-1.025-1.793 3.022-3.478.19-.662 3.46-3.204 1.384.547 3.48-2.544 2.409 1.69 3.082-1.575 3.144 2.63 2.31-.42 3.5 3.253 1.261.789 3.433 3.482.06 1.902 2.953zm3.39-15.13H18.56v2.526h3.494v2.022h-5.491V14.522h5.491v2.022H18.56v2.526h2.371zm-11.36 4.674H7.576V14.522h2.449l3.168 7.181v-7.307h1.997V25.64h-2.448l-3.168-7.18zm22.467-.126h-2.437l-1.932-3.62-1.93 3.62h-2.438V14.396H25.3v7.812l2.371-4.444 2.371 4.444v-7.812h1.998zm-11.67 6.823c-1.98 0-3.894-.413-5.688-1.227l.817-1.845a11.872 11.872 0 009.74 0l.818 1.845a13.684 13.684 0 01-5.687 1.227zm4.87-21.692a11.882 11.882 0 00-9.74 0l-.818-1.845a13.86 13.86 0 0111.375 0z"></path>
                                </svg>
                            </div>
                            <span><?php echo __('New', 'mostbet'); ?></span>
                        </a>
                    </li>
                    <li>
                        <a class="promotion__link" href="<?php echo $sidebar_left_link3; ?>" target="_blank"
                           rel="nofollow">
                            <div class="promotion__icon">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 40 40">
                                    <path d="M19.997 40c-1.328 0-2.502-.594-3.256-1.602-1.054.69-2.359.849-3.609.396-1.248-.453-2.147-1.411-2.51-2.614-1.227.288-2.508-.01-3.526-.86-1.018-.85-1.534-2.057-1.462-3.311-1.25-.147-2.354-.863-3.018-2.009-.664-1.146-.736-2.456-.237-3.61C1.253 25.825.462 24.776.23 23.473.001 22.169.383 20.914 1.248 20 .384 19.085 0 17.83.23 16.526c.231-1.303 1.021-2.352 2.148-2.917-.499-1.153-.428-2.463.237-3.61.664-1.145 1.766-1.862 3.018-2.009-.072-1.254.444-2.46 1.462-3.311 1.018-.85 2.3-1.147 3.527-.86.362-1.203 1.261-2.16 2.51-2.613 1.248-.452 2.554-.295 3.608.395C17.494.594 18.668 0 19.996 0c1.329 0 2.503.594 3.256 1.6 1.054-.689 2.362-.846 3.61-.394 1.247.453 2.146 1.41 2.509 2.613 1.227-.287 2.508.008 3.527.86 1.017.85 1.534 2.057 1.461 3.311 1.253.147 2.355.864 3.02 2.009.664 1.147.735 2.457.236 3.611 1.127.565 1.917 1.614 2.147 2.916.231 1.304-.152 2.559-1.016 3.474.865.915 1.247 2.17 1.016 3.473-.23 1.303-1.021 2.352-2.147 2.917.499 1.154.427 2.464-.237 3.61-.664 1.146-1.767 1.862-3.019 2.009.073 1.255-.444 2.46-1.461 3.311-1.018.85-2.3 1.148-3.526.86-.363 1.203-1.262 2.16-2.51 2.614-1.248.453-2.556.294-3.61-.394-.753 1.006-1.927 1.6-3.255 1.6zm-2.97-4.21a1.005 1.005 0 01.932.63l.108.272c.384.964 1.248 1.308 1.93 1.308.681 0 1.546-.344 1.93-1.307l.108-.271a1 1 0 01.758-.616.994.994 0 01.925.32l.196.22c.69.772 1.618.8 2.26.568.641-.232 1.336-.848 1.366-1.884l.009-.296a1.004 1.004 0 011.48-.85l.26.14c.914.494 1.797.2 2.319-.236s.963-1.253.636-2.236l-.093-.277a.998.998 0 01.183-.958.996.996 0 01.913-.347l.291.042c1.026.151 1.762-.423 2.102-1.012.34-.589.475-1.507-.17-2.32l-.182-.227a.997.997 0 01-.157-.963c.119-.326.399-.568.74-.638l.289-.06c1.018-.209 1.507-.998 1.626-1.667.118-.668-.07-1.577-.956-2.12l-.249-.152a1 1 0 01-.002-1.703l.25-.155c.886-.544 1.075-1.453.957-2.12-.119-.67-.608-1.459-1.626-1.668l-.286-.059a.997.997 0 01-.586-1.6l.183-.23c.644-.812.51-1.73.17-2.319-.341-.589-1.075-1.16-2.1-1.012l-.29.043a1.013 1.013 0 01-.916-.346.996.996 0 01-.184-.959l.093-.279c.327-.982-.114-1.798-.636-2.235-.522-.437-1.407-.728-2.32-.236l-.259.14a1.005 1.005 0 01-1.48-.85l-.01-.293c-.029-1.037-.724-1.655-1.364-1.886-.64-.232-1.57-.205-2.262.568l-.197.22a.997.997 0 01-.924.32 1.001 1.001 0 01-.757-.617l-.108-.271C21.543 2.343 20.678 2 19.997 2c-.682 0-1.546.343-1.93 1.306l-.109.273a1 1 0 01-.757.614.997.997 0 01-.924-.318l-.196-.219c-.692-.775-1.623-.804-2.262-.57-.64.231-1.335.849-1.365 1.884l-.009.293a1 1 0 01-.5.838 1.013 1.013 0 01-.98.013l-.259-.14c-.913-.49-1.797-.2-2.32.237-.522.437-.963 1.253-.636 2.235l.093.282c.11.329.04.691-.185.957a1.011 1.011 0 01-.915.345l-.291-.043C5.427 9.84 4.694 10.41 4.354 11c-.34.589-.476 1.507.17 2.32l.183.23a.997.997 0 01-.587 1.6l-.289.058c-1.016.21-1.505.998-1.623 1.667-.119.668.07 1.577.955 2.12l.252.156a.997.997 0 01-.003 1.703l-.25.153c-.884.542-1.073 1.451-.954 2.119.118.669.607 1.458 1.625 1.667l.29.06a.997.997 0 01.583 1.602l-.183.229c-.645.81-.51 1.728-.169 2.317.34.588 1.073 1.161 2.099 1.012l.294-.042c.345-.056.69.08.913.347a.997.997 0 01.183.957l-.093.278c-.327.983.114 1.8.636 2.236.522.438 1.407.728 2.32.236l.26-.14a1.01 1.01 0 01.978.015 1 1 0 01.501.837l.009.294c.03 1.036.725 1.652 1.365 1.884.64.233 1.57.204 2.261-.568l.196-.22c.192-.216.466-.336.75-.336z"></path>
                                    <path fill="#ffba00"
                                          d="M20 9l3.296 5.971 6.703 1.286-4.666 4.977L26.18 28 20 25.104 13.82 28l.847-6.766-4.666-4.977 6.703-1.286L20 9.001m3.707 15.68l-.508-4.268 2.796-3.14-4.017-.811-1.976-3.77-1.977 3.77-4.015.811 2.795 3.14-.508 4.269 3.705-1.828z"></path>
                                </svg>
                            </div>
                            <span><?php echo __('Favourites', 'mostbet'); ?></span>
                        </a>
                    </li>
                    <li>
                        <form class="promotion__form" action="<?php echo home_url('/') ?>">
                            <div class="promotion__search">
                                <button type="button" class="search__btn">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                                        <path d="M9 18a9 9 0 117.06-3.418l3.618 3.618a1.045 1.045 0 01-1.478 1.478l-3.618-3.618A8.962 8.962 0 019 18zM9 2a7 7 0 100 14A7 7 0 009 2zM6 9a1 1 0 11-2 0 5 5 0 015-5 1 1 0 010 2 3 3 0 00-3 3z"></path>
                                    </svg>
                                </button>
                                <input type="text" class="search__inp"
                                       placeholder="<?php echo __('Search...', 'mostbet'); ?>"
                                       value="" name="s">
                            </div>
                        </form>
                    </li>
                </ul>
                <div class="promotion__menu">
                    <a class="header__link" href="<?php echo $sidebar_left_link4; ?>" target="_blank"
                       rel="nofollow"><?php echo __('Line', 'mostbet'); ?></a>
                    <a class="header__link" href="<?php echo $sidebar_left_link5; ?>" target="_blank"
                       rel="nofollow"><?php echo __('Live', 'mostbet'); ?></a>
                    <a class="header__link" href="<?php echo $sidebar_left_link6; ?>" target="_blank"
                       rel="nofollow"><?php echo __('Casino', 'mostbet'); ?></a>
                    <a class="header__link" href="<?php echo $sidebar_left_link7; ?>" target="_blank"
                       rel="nofollow"><?php echo __('Live-casino', 'mostbet'); ?></a>
                    <a class="aviator__href" href="<?php echo $all_links; ?>" target="_blank" rel="nofollow">
                <span class="aviator__logo">
                    <svg viewBox="0 0 131 35" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio=""><path
                                d="M43.5 11.5l-3.9 15.4c-.3 1.2-1 2.3-2.2 3.2-1.1.9-2.3 1.3-3.6 1.3l5-19.8h-6.2l-.6 3-5 19.8h6c2.9 0 5.7-1.1 8.4-3.3 2.6-2.2 4.3-4.7 5-7.7l2.2-8.9.8-3z"></path><path
                                d="M54.5 29.1c0-.1 0-.1.1-.2 0-.1.1-.1.1-.2L59 11.5H49l-.8 3h4l-3.6 14.2c-.1.1-.1.3-.1.5-.3 1.6.1 2.8 1.2 3.7 1 .9 2.6 1.4 4.7 1.4h.9l.8-3c-1.3-.2-1.8-1-1.6-2.2zm5.7-27c-.5-.6-1.2-.9-2-.9s-1.6.3-2.3.9-1.1 1.3-1.2 2.2 0 1.6.5 2.2 1.2.9 2 .9 1.6-.3 2.3-.9 1.1-1.3 1.3-2.2c.1-.9-.1-1.6-.6-2.2zm16.5 27.5c0-.1 0-.1.1-.2 0-.1 0-.1.1-.2l4.4-17.8H70.9c-2.2 0-4.2.6-6 1.8-1.9 1.2-3 2.7-3.5 4.6l-2.5 10.1c-.1.2-.1.3-.1.6-.3 1.7.2 3.1 1.5 4.1 1.3 1.1 2.9 1.6 4.9 1.6h.9c1.8 0 3.4-.6 4.9-1.8.8 1.2 2.2 1.8 4.3 1.8h2.1l.8-3c-1.2 0-1.7-.6-1.5-1.6zm-5.6-1.7c-.2.9-.8 1.7-1.6 2.4s-1.7 1-2.6 1c-1.7 0-2.5-.8-2.2-2.5 0 0 0-.1.1-.2 0-.1.1-.2.1-.3l2.9-11.5c.4-1.5 1.2-2.2 2.5-2.2h4.3zm39.4-14.8c-1.2-1.1-2.9-1.6-4.9-1.6h-.9c-2.2 0-4.2.6-6.1 1.8-1.8 1.2-3 2.7-3.4 4.5l-2.6 10.1c-.1.2-.1.3-.1.6-.3 1.7.2 3.1 1.5 4.2s2.9 1.6 5 1.6h.9c2.2 0 4.2-.6 6.1-1.9 1.9-1.2 3-2.7 3.4-4.5l2.5-10.1.1-.6c.2-1.6-.3-3-1.5-4.1zm-4.6 4.2l-.1.5-2.5 10.1c-.3 1.1-.7 1.9-1.3 2.5s-1.2.9-1.9.9c-.6 0-1.1-.3-1.4-.8s-.4-1.2-.3-2.1c0-.1 0-.1.1-.2 0-.1.1-.2.1-.2l2.5-10.1c.3-1 .7-1.8 1.2-2.4.6-.6 1.2-.9 1.9-.9.6 0 1.1.2 1.4.7.3.4.4 1.1.3 2zm23.1-5.8c-2.4 0-4.5.6-6.3 1.9l.5-1.9h-6l-5.7 22.8h6l3.1-12.5c.4-1.5 1.2-3 2.3-4.3 1.2-1.3 2.5-2.3 3.9-2.8l-.7 3h3.3l1.6-6.2zM27.9 2.9c-1.4-1.1-3.2-1.7-5.6-1.7-2.5 0-4.8.6-6.7 1.9s-3.2 3-3.7 5.1l-2.5 9.9H3.8C1.7 18.1 0 19.8 0 22h8.5L5.4 34.3h6l3-12.3h5.4l-1.9 7.6c-.1.1-.1.3-.1.6-.2 1.3 0 2.3.8 3 .7.7 1.8 1.1 3.3 1.1h2.4l.8-3c-.9-.1-1.2-.5-1.1-1.4l5.4-21.7c0-.1 0-.2.1-.4 0-.2.1-.3.1-.4.2-1.9-.3-3.4-1.7-4.5zM15.4 18.1l2.8-10.8c.2-.9.6-1.6 1.3-2.2.6-.6 1.4-.9 2.2-.9s1.3.3 1.7.8.5 1.2.4 1.9l-.1.4-2.8 10.8v.1h-5.5zm77-6.6l1.4-5.3h-6l-1.3 5.3h-3l-.8 3h3l-3.6 14.2c0 .1 0 .2-.1.3 0 .2-.1.3-.1.3-.3 1.5 0 2.7.9 3.6.8.9 2.1 1.3 3.8 1.3h2.1l.8-3.1c-1.2-.1-1.8-.8-1.5-2.1 0-.1 0-.1.1-.2 0-.1 0-.1.1-.2l3.6-14.2h2.6l.8-3h-2.8z"></path>
                    </svg>
                </span>
                        <span class="aviator__icon">
                    <svg viewBox="0 0 282.38 133.2" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="">
                            <path d="M225.18 48.18l-40.51-7.86 40.5-16.27 7.94 9.23z"></path><path
                                d="M278.69 27.35C273.85 16.76 270.3 7.71 269 5.54c-3.7-6.26-9.21-5.92-13.94-5.1-12.61 2.17-17.53 4.39-39.76 10.3-3.27.9-9.44 2.71-12.84 1.53-9-3.08-11.73-5.55-16.05-5.06-6.66.79-20.41 7.23-35.34 18.14-4.67 3.36-4.13 7.38-5 10a1 1 0 00.62 1.18h.18c2.17.22 25.86 2.28 26.94 2.43a1 1 0 01-.54-.88.86.86 0 01.49-.8c6.76-3.64 31.32-16.65 46.15-22.5 20.29-8 25.19-8.91 31.35-9.49a36.88 36.88 0 014.93.06 3 3 0 012.62 1.93c2.8 8.22 11 26.79 15.34 32.94a3 3 0 01-2.2 1.52c-1.14 0-3.46-2.13-4.9-3.4a1 1 0 00-1.14-.07c-24.33 15-41.87 21.54-44.4 22.44a.79.79 0 01-.64 0l-12.43-4.63a10.24 10.24 0 001.63-2.71 3.9 3.9 0 00.35-1.55c-.09-2-2-2.43-2.86-2.54-3.31-.41-92.12-13.51-114.39-15.7-9.45-1-18.44 3.89-22.33 9v.13l12.61 13.17a.92.92 0 001.07.21l9.92-4.57s1.36 4.2.09 4.91C86.29 61 78.31 65 70.59 69c-3.1 1.64-3 4.74-4 9.1-.42 1.9-.59 3.53-.59 3.53S83.25 73 93.85 67.9a1 1 0 011.08.21c1.51 1.63 2 2 3 3a.94.94 0 010 1.33.82.82 0 01-.22.16c-2.5 1.33-5.08 2.69-7.06 3.87-1.57.93 0 4.06 0 4.06l28.79-13.64s1.79 1.77-1.38 3.74C113.15 73.71 67.74 96.86 63.84 97c-10.3.26-29.73-19.12-36.75-22.07-5.92-2.49-12.3 1.57-20.95 6.65-2.35 1.4-.92 4.78-.92 4.78L17.76 80s1.55 1.79-.19 2.88c-6.07 3.85-14.85 7.7-16.2 8.67-2 1.42-1.22 8.07-1.22 8.07L12 94.09a1 1 0 011 .06l25.42 24.2a28.07 28.07 0 004.71-1.59l-21.2-22.55a1 1 0 01.14-1.4l.12-.09c2.17-1.1 4.76-1.91 8.43.9 3.08 2.38 13.86 11.06 24.29 10.13 3.48-.3 3.53.77 3.53.77s-4.43 2.13-9.68 5c-2.6 1.44-.49 5.23-.49 5.23 26.87-11 60-24.74 64.6-26.74a1 1 0 011 .13l7.77 6.17c1.1 1.69 56.36-19.53 73.41-28.14 1-.47 9.62-.07 13.81-.11 1.92 0 1.85.84 1.85.84S72.42 122 38.49 120.77h-.06l-7.23 3.1c4.24 2.8 3.23 7.64 10.45 3.9.43 1 .93 2 1.46 3.16 1.4 3 1.4 3.06 10.58-.06 26-8.78 142.68-43.67 168.82-54.49 14.76-6.09 35.17-14.5 47.89-22.38 12.6-7.72 15.11-11.72 8.29-26.65zM167 27.89c-1.57 1.12-11.91-.81-11.91-.81s11.44-10.17 22.33-11.47c3.24-.39 9.79 2.15 9.79 2.15s-14.59 6.1-20.21 10.13zm34.7-10.12L187 25.35s-3.42-2.07.43-3.81c1-.45 3.25-1.74 5.08-2.69a1.34 1.34 0 00-.13-2.43l-11-4.39a8.43 8.43 0 017.47-1.53c1.59.49 8.24 3.29 12.61 5.12a1.16 1.16 0 01.87 1.38 1.13 1.13 0 01-.61.77zm3.7 35.73c-1.44 2.13-4.8 6.09-9.74 5.29-2.41-.41-100.49-20.31-100.73-20.33-.69-.19-.6-1.66.65-1.51L204.75 52a1 1 0 01.78 1.19 1.07 1.07 0 01-.13.31zm70.88-44.73l-.3.07a.78.78 0 00-.26.17l1-.26z"></path><path
                                d="M244.42 10.2s-1.78 7.37-4.59 15.87l-5.2-6.57-4.21 1.92 7.66 9.7c-2.39 6.54-5.27 13.05-8.34 16.89l7.68-3.49c1.75-1.62 3.16-4.9 4.26-8.84L245.9 41l4.24-1.93-7.16-9c1.56-8.19 2.02-17.07 1.44-19.87z"></path>
                    </svg>
                    <span class="propeller"></span>
                </span>
                    </a>
                    <a class="buy-bonus" href="<?php echo $all_links; ?>">
                <span class="buy-bonus-icon">
                    <svg viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg" class=""
                         preserveAspectRatio="">
                        <g clip-path="url(#clip0_8219_554__a01KH7jk)">
                            <path d="M7.37 19.68a2.13 2.13 0 01-.808-4.09 2.12 2.12 0 012.308.46c.394.4.616.938.62 1.5a2.13 2.13 0 01-2.12 2.13zm7.4 0a2.13 2.13 0 01-.808-4.09 2.12 2.12 0 012.308.46c.394.4.616.938.62 1.5a2.13 2.13 0 01-2.12 2.13zM.99 4.68a1 1 0 01-.926-1.384A1 1 0 01.28 2.97a1 1 0 01.7-.31h1.21a2 2 0 012 1.6l1.32 6a2 2 0 002 1.6h7.94l1.53-6.13H14.1a1 1 0 01-.69-.31.998.998 0 010-1.42 1 1 0 01.69-.31h2.88a2.07 2.07 0 011.6.78c.19.248.322.535.39.84a2 2 0 010 .92l-1.52 6.13a2 2 0 01-.73 1.11 2 2 0 01-1.25.43H7.53a4.08 4.08 0 01-2.55-.89 4.13 4.13 0 01-1.42-2.31l-1.33-6-1.24-.02zm11.16-2.39l-1.78-.15a.47.47 0 01-.38-.27L9.29.23a.45.45 0 00-.82 0l-.7 1.65a.47.47 0 01-.38.27l-1.78.15a.45.45 0 00-.26.79l1.39 1.17a.44.44 0 01.14.45l-.4 1.72a.45.45 0 00.66.49l1.54-.93a.47.47 0 01.46 0l1.54.92a.45.45 0 00.67-.48l-.4-1.73a.439.439 0 01.14-.45l1.35-1.15a.45.45 0 00-.29-.77v-.04z"></path>
                        </g>
                        <defs>
                            <clipPath id="clip0_8219_554__a01KH7jk">
                                <path fill="#fff" d="M0 0h20v20H0z"></path>
                            </clipPath>
                        </defs>
                    </svg>
                </span>
                        <span><?php echo __('BUY BONUS', 'mostbet'); ?></span>
                    </a>
                    <a class="header__link" href="<?php echo $sidebar_left_link8; ?>" target="_blank"
                       rel="nofollow"><?php echo __('Cybersport', 'mostbet'); ?></a>
                    <a class="header__link" href="<?php echo $sidebar_left_link9; ?>" target="_blank"
                       rel="nofollow"><?php echo __('Poker', 'mostbet'); ?></a>
                    <a class="header__link" href="<?php echo $sidebar_left_link10; ?>" target="_blank"
                       rel="nofollow"><?php echo __('Toto', 'mostbet'); ?></a>
                </div>
            </div>
        </div>
    </div>


</header>